/**
* Script: animate.js
* Written by: Radnen
* Updated: 11/18/2010
*/

const ANIMATE = COMMAND_ANIMATE;
const NORTH   = COMMAND_MOVE_NORTH;
const SOUTH   = COMMAND_MOVE_SOUTH;
const EAST    = COMMAND_MOVE_EAST;
const WEST    = COMMAND_MOVE_WEST;
const WAIT    = COMMAND_WAIT;

/*
	Returns the direction number of a spriteset.
*/
function GetDirectionNum(ss, direction)
{
	for (var i = 0; i < ss.directions.length; ++i) {
		if (ss.directions[i].name == direction) return i;
	}
	throw "could not find direction: \"" + direction + "\" in entity."; 
}

/*
	Animate function. It has a conditional for staying on last frame. This can
	be used for battle or in a cinematic when a certain animation needs playing.
*/
function Animate(person, direction)
{
	QueuePersonScript(person, 'SetPersonDirection("' + person + '", "' + direction + '");', true);
	QueuePersonScript(person, 'SetPersonFrame("' + person + '", 0);', true);
	var SS = GetPersonSpriteset(person);
	var D = SS.directions[GetDirectionNum(SS, direction)];
	var Delay = 0;
	var FRAMES = D.frames.length-1;
	do{ Delay+= D.frames[FRAMES].delay; }while(FRAMES--);

	--Delay;
	do{
		QueuePersonCommand(person, COMMAND_ANIMATE, false);
	}while(--Delay);

}

/*
	CreateEntityAnimation() is used to create a person that runs
	through an animate cycle and destroys itself when done. 
*/
function CreateEntityAnimation(name, spriteset, x, y, direction, layer)
{
	CreatePerson(name, spriteset, true);
	SetPersonXYFloat(name, x, y);
	SetPersonLayer(name, layer);
	AnimateDestroy(name, direction);
}

/*
	Will animate the entity and destroy it on animation end.
*/
function AnimateDestroy(person, direction)
{
	Animate(person, direction, true);
	SetPersonScript(person, SCRIPT_COMMAND_GENERATOR, 'WaitUntilClear()');
}

function WaitUntilClear()
{
	if (IsCommandQueueEmpty(GetCurrentPerson())) DestroyPerson(GetCurrentPerson());
}